/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.CheckTable;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchsupport.action.RestApi;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchGuardCapabilities {
    private static final Logger log = LogManager.getLogger(SearchGuardCapabilities.class);
    private final Client nodeClient;
    private final Capabilities local;
    private volatile Capabilities clusterWide;
    private final ConcurrentHashMap<String, Capabilities> byNode = new ConcurrentHashMap();
    private final ClusterStateListener clusterStateListener = new ClusterStateListener(){

        public void clusterChanged(ClusterChangedEvent event) {
            if (!event.nodesChanged()) {
                return;
            }
            DiscoveryNodes.Delta nodesDelta = event.nodesDelta();
            if (nodesDelta.removed()) {
                for (DiscoveryNode node : nodesDelta.removedNodes()) {
                    SearchGuardCapabilities.this.byNode.remove(node.getId());
                }
                SearchGuardCapabilities.this.calculateIntersectionOfCapabilities();
            }
            if (nodesDelta.added()) {
                SearchGuardCapabilities.this.nodeClient.execute((ActionType)GetCapabilitiesAction.INSTANCE, (ActionRequest)new GetCapabilitiesAction.Request(nodesDelta.addedNodes()), (ActionListener)new ActionListener<GetCapabilitiesAction.Response>(){

                    public void onResponse(GetCapabilitiesAction.Response response) {
                        try {
                            for (GetCapabilitiesAction.NodeResponse nodeResponse : response.getNodes()) {
                                SearchGuardCapabilities.this.byNode.put(nodeResponse.getNode().getId(), nodeResponse.getCapabilities());
                            }
                            for (FailedNodeException failure : response.failures()) {
                                if (failure.getCause() instanceof RemoteTransportException && failure.getCause().getCause() instanceof ActionNotFoundTransportException) {
                                    log.debug("Remote node does not know the GetCapabilitiesAction. Assuming fallback capabilities", (Throwable)failure);
                                    SearchGuardCapabilities.this.byNode.put(failure.nodeId(), Capabilities.LEGACY_ASSUMED_CAPABILITIES);
                                    continue;
                                }
                                log.warn("Got failure from node when retrieving capabilities", (Throwable)failure);
                                SearchGuardCapabilities.this.byNode.remove(failure.nodeId());
                            }
                            SearchGuardCapabilities.this.calculateIntersectionOfCapabilities();
                        }
                        catch (Exception e) {
                            log.error("Error while updating capabilities: " + (Object)((Object)response), (Throwable)e);
                        }
                    }

                    public void onFailure(Exception e) {
                        log.error("Error when retrieving capabilities", (Throwable)e);
                    }
                });
            }
        }
    };

    SearchGuardCapabilities(Collection<SearchGuardModule> modules, ClusterService clusterService, Client nodeClient) {
        ImmutableSet capabilities = ImmutableSet.of(modules.stream().flatMap(m -> m.getCapabilities().stream()).collect(Collectors.toSet()));
        ImmutableSet uiCapabilities = ImmutableSet.of(modules.stream().flatMap(m -> m.getUiCapabilities().stream()).collect(Collectors.toSet()));
        ImmutableSet publicCapabilites = ImmutableSet.of(modules.stream().flatMap(m -> m.getPublicCapabilities().stream()).collect(Collectors.toSet()));
        this.clusterWide = this.local = new Capabilities(SearchGuardVersion.getVersion(), (ImmutableSet<String>)capabilities, (ImmutableSet<String>)uiCapabilities, (ImmutableSet<String>)publicCapabilites);
        this.nodeClient = nodeClient;
        if (clusterService != null) {
            clusterService.addListener(this.clusterStateListener);
        }
    }

    public boolean hasCapability(String capability) {
        return this.clusterWide.hasCapability(capability);
    }

    public ImmutableSet<String> getCapabilities() {
        return this.clusterWide.getCapabilities();
    }

    public ImmutableSet<String> getUiCapabilities() {
        return this.clusterWide.getUiCapabilities();
    }

    public ImmutableSet<String> getPublicCapabilites() {
        return this.clusterWide.getPublicCapabilites();
    }

    private void calculateIntersectionOfCapabilities() {
        ImmutableMap copy = ImmutableMap.of(this.byNode);
        ImmutableSet nodes = copy.keySet();
        if (this.local.allCapabilities.isEmpty()) {
            this.clusterWide = Capabilities.EMPTY;
            return;
        }
        if (nodes.isEmpty()) {
            Capabilities newClusterWide;
            Capabilities oldClusterWide = this.clusterWide;
            this.clusterWide = newClusterWide = this.local;
            log.info("Updated capabilities: " + newClusterWide + "\nOld: " + oldClusterWide);
            return;
        }
        CheckTable capabilities = !this.local.capabilities.isEmpty() ? CheckTable.create((Set)nodes, this.local.capabilities) : null;
        CheckTable uiCapabilities = !this.local.uiCapabilities.isEmpty() ? CheckTable.create((Set)nodes, this.local.uiCapabilities) : null;
        CheckTable publicCapabilities = !this.local.publicCapabilities.isEmpty() ? CheckTable.create((Set)nodes, this.local.publicCapabilities) : null;
        TreeSet<String> versions = new TreeSet<String>();
        versions.add(this.local.searchGuardVersion);
        for (Map.Entry entry : copy.entrySet()) {
            versions.add(((Capabilities)entry.getValue()).searchGuardVersion != null ? ((Capabilities)entry.getValue()).searchGuardVersion : "_unknown");
            if (capabilities != null) {
                capabilities.checkIf((Object)((String)entry.getKey()), c -> ((Capabilities)entry.getValue()).capabilities.contains(c));
            }
            if (uiCapabilities != null) {
                uiCapabilities.checkIf((Object)((String)entry.getKey()), c -> ((Capabilities)entry.getValue()).uiCapabilities.contains(c));
            }
            if (publicCapabilities == null) continue;
            publicCapabilities.checkIf((Object)((String)entry.getKey()), c -> ((Capabilities)entry.getValue()).publicCapabilities.contains(c));
        }
        Capabilities oldClusterWide = this.clusterWide;
        Capabilities newClusterWide = new Capabilities(String.join((CharSequence)", ", versions), (ImmutableSet<String>)(capabilities != null ? capabilities.getCompleteColumns() : ImmutableSet.empty()), (ImmutableSet<String>)(uiCapabilities != null ? uiCapabilities.getCompleteColumns() : ImmutableSet.empty()), (ImmutableSet<String>)(publicCapabilities != null ? publicCapabilities.getCompleteColumns() : ImmutableSet.empty()));
        if (oldClusterWide == null) {
            log.info("Initial capabilities: " + newClusterWide);
            this.clusterWide = newClusterWide;
        } else if (!oldClusterWide.equals(newClusterWide)) {
            log.info("Updated capabilities: " + newClusterWide + "\nOld: " + oldClusterWide);
            this.clusterWide = newClusterWide;
        } else {
            log.debug("Capabilities did not change");
        }
    }

    public static class GetCapabilitiesAction
    extends ActionType<Response> {
        public static final GetCapabilitiesAction INSTANCE = new GetCapabilitiesAction();
        public static final String NAME = "cluster:admin/searchguard/capabilities/cluster_wide/get";
        public static final RestApi REST_API = new RestApi().responseHeaders(SearchGuardVersion.header()).handlesGet("/_searchguard/capabilities/cluster_wide").with((ActionType)INSTANCE, (params, body) -> new Request()).name("/_searchguard/capabilities/cluster_wide");

        protected GetCapabilitiesAction() {
            super(NAME, Response::new);
        }

        public static class TransportAction
        extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse> {
            private final SearchGuardCapabilities capabilities;

            @Inject
            public TransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, SearchGuardCapabilities capabilities) {
                super(GetCapabilitiesAction.NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "management", NodeResponse.class);
                this.capabilities = capabilities;
            }

            protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
                return new NodeResponse(in);
            }

            protected Response newResponse(Request request, List<NodeResponse> responses, List<FailedNodeException> failures) {
                return new Response(this.clusterService.getClusterName(), responses, failures);
            }

            protected NodeResponse nodeOperation(NodeRequest request) {
                return new NodeResponse(this.clusterService.localNode(), this.capabilities.local);
            }

            protected NodeRequest newNodeRequest(Request request) {
                return new NodeRequest();
            }
        }

        public static class NodeResponse
        extends BaseNodeResponse
        implements ToXContentObject {
            private final Capabilities capabilities;

            public NodeResponse(StreamInput in) throws IOException {
                super(in);
                this.capabilities = new Capabilities(in);
            }

            public NodeResponse(DiscoveryNode node, Capabilities capabilities) {
                super(node);
                this.capabilities = capabilities;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                this.capabilities.writeTo(out);
            }

            public Capabilities getCapabilities() {
                return this.capabilities;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.map((Map)this.capabilities.toBasicObject());
                return builder;
            }
        }

        public static class NodeRequest
        extends BaseNodeRequest {
            public NodeRequest(StreamInput in) throws IOException {
                super(in);
            }

            public NodeRequest() {
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
            }
        }

        public static class Response
        extends BaseNodesResponse<NodeResponse>
        implements StatusToXContentObject {
            public Response(StreamInput in) throws IOException {
                super(in);
            }

            public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
                super(clusterName, nodes, failures);
            }

            public List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
                return in.readList(NodeResponse::new);
            }

            public void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
                out.writeList(nodes);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("nodes", (Object)this.getNodesMap());
                if (this.hasFailures()) {
                    builder.field("failures");
                    builder.startArray();
                    for (FailedNodeException failure : this.failures()) {
                        builder.startObject();
                        failure.toXContent(builder, params);
                        builder.endObject();
                    }
                    builder.endArray();
                }
                builder.endObject();
                return builder;
            }

            public RestStatus status() {
                return RestStatus.OK;
            }
        }

        public static class Request
        extends BaseNodesRequest<Request> {
            Request() {
                super(new String[0]);
            }

            Request(StreamInput in) throws IOException {
                super(in);
            }

            Request(Collection<DiscoveryNode> concreteNodes) {
                super(concreteNodes.toArray(new DiscoveryNode[concreteNodes.size()]));
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
            }
        }
    }

    static class Capabilities
    implements Writeable,
    Document<Capabilities> {
        static final Capabilities EMPTY = new Capabilities(null, (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<String>)ImmutableSet.empty());
        static final Capabilities LEGACY_ASSUMED_CAPABILITIES = new Capabilities("_unknown", (ImmutableSet<String>)ImmutableSet.of((Object)"auth_tokens", (Object[])new String[]{"fe_multi_tenancy", "signals"}), (ImmutableSet<String>)ImmutableSet.empty(), (ImmutableSet<String>)ImmutableSet.empty());
        final String searchGuardVersion;
        final ImmutableSet<String> capabilities;
        final ImmutableSet<String> uiCapabilities;
        final ImmutableSet<String> publicCapabilities;
        final ImmutableSet<String> allCapabilities;

        Capabilities(String searchGuardVersion, ImmutableSet<String> capabilities, ImmutableSet<String> uiCapabilities, ImmutableSet<String> publicCapabilites) {
            this.searchGuardVersion = searchGuardVersion;
            this.capabilities = capabilities;
            this.uiCapabilities = uiCapabilities;
            this.publicCapabilities = publicCapabilites;
            this.allCapabilities = capabilities.with(uiCapabilities).with(publicCapabilites);
        }

        Capabilities(StreamInput in) throws IOException {
            this.searchGuardVersion = in.readOptionalString();
            this.capabilities = ImmutableSet.of((Set)in.readSet(StreamInput::readString));
            this.uiCapabilities = ImmutableSet.of((Set)in.readSet(StreamInput::readString));
            this.publicCapabilities = ImmutableSet.of((Set)in.readSet(StreamInput::readString));
            this.allCapabilities = this.capabilities.with(this.uiCapabilities).with(this.publicCapabilities);
        }

        boolean hasCapability(String capability) {
            return this.allCapabilities.contains((Object)capability);
        }

        ImmutableSet<String> getCapabilities() {
            return this.capabilities;
        }

        ImmutableSet<String> getUiCapabilities() {
            return this.uiCapabilities;
        }

        ImmutableSet<String> getPublicCapabilites() {
            return this.publicCapabilities;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.searchGuardVersion);
            out.writeCollection(this.capabilities, StreamOutput::writeString);
            out.writeCollection(this.uiCapabilities, StreamOutput::writeString);
            out.writeCollection(this.publicCapabilities, StreamOutput::writeString);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
            result = 31 * result + (this.publicCapabilities == null ? 0 : this.publicCapabilities.hashCode());
            result = 31 * result + (this.uiCapabilities == null ? 0 : this.uiCapabilities.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Capabilities)) {
                return false;
            }
            Capabilities other = (Capabilities)obj;
            return this.capabilities.equals(other.capabilities) && this.publicCapabilities.equals(other.publicCapabilities) && this.uiCapabilities.equals(other.uiCapabilities);
        }

        public String toString() {
            return "Capabilities [searchGuardVersion=" + this.searchGuardVersion + ", capabilities=" + this.capabilities + ", uiCapabilities=" + this.uiCapabilities + ", publicCapabilities=" + this.publicCapabilities + "]";
        }

        public Map<String, Object> toBasicObject() {
            return ImmutableMap.of((Object)"version", (Object)this.searchGuardVersion, (Object)"capabilities", this.capabilities, (Object)"ui_capabilities", this.uiCapabilities, (Object)"public_capabilities", this.publicCapabilities);
        }
    }
}

